import { WebPlugin, } from "@capacitor/core";
export class SplashScreenPluginElectron extends WebPlugin {
    constructor() {
        super({
            name: "SplashScreen",
            platforms: ["electron"],
        });
        this.ipc = null;
        this.ipc = require("electron").ipcRenderer;
    }
    async show(options, callback) {
        this.ipc.send("showCapacitorSplashScreen", Object.assign({}, options));
        if (callback) {
            callback();
        }
    }
    async hide(options, callback) {
        this.ipc.send("hideCapacitorSplashScreen", Object.assign({}, options));
        if (callback) {
            callback();
        }
    }
}
const SplashScreen = new SplashScreenPluginElectron();
export { SplashScreen };
//# sourceMappingURL=splashscreen.js.map